#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gres=gpu:2
#SBATCH --ntasks-per-node=1
#SBATCH --partition=gpu
#SBATCH --cpus-per-task=9
#SBATCH --job-name=KP
#SBATCH --time=20:00:00
#SBATCH --mem=80G
#SBATCH --constraint=gmem24G
#SBATCH --constraint=p40
#SBATCH --exclude=gnodee8,gnodec1
#SBATCH --sockets-per-node=1


PYTHON='/scratch/shared/beegfs/yuki/envs/py37/bin/python3'

EXP_STR=$1


EXPERIMENT_PATH="/scratch/shared/beegfs/yuki/adiwol/experiments/yuki/${EXP_STR}"
OUTPUT_DIR="${EXPERIMENT_PATH}/KP_5p_1x_syncbn_18k"
mkdir -p ${OUTPUT_DIR}

cd detection

${PYTHON} train_kp.py --config-file configs/kp_5p.yaml \
        --num-gpus 2  --dist-url "auto" --resume \
        SOLVER.IMS_PER_BATCH 8 SOLVER.BASE_LR 0.01 \
        SOLVER.STEPS "(12000, 16000)" SOLVER.MAX_ITER 18000 \
        SOLVER.CHECKPOINT_PERIOD 600 \
        MODEL.WEIGHTS ${EXPERIMENT_PATH}/converted.pkl \
        OUTPUT_DIR ${OUTPUT_DIR}
